<?php
require_once '../config.php';
verificarLogin();

$titulo = "Servidores";
$security = new Security($pdo);

// Buscar servidores DO USUÁRIO ATUAL
$stmt = $pdo->prepare("SELECT * FROM servidores WHERE usuario_id = ? ORDER BY nome");
$stmt->execute([$_SESSION['usuario_id']]);
$servidores = $stmt->fetchAll();

// Contar clientes por servidor DO USUÁRIO ATUAL
$stmt = $pdo->prepare("SELECT servidor_id, COUNT(*) as total FROM clientes WHERE servidor_id IS NOT NULL AND usuario_id = ? GROUP BY servidor_id");
$stmt->execute([$_SESSION['usuario_id']]);
$clientes_por_servidor = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        :root {
            --primary: #667eea;
            --secondary: #2d3748;
            --warning: #ed8936;
            --danger: #f56565;
            --success: #48bb78;
        }
        
        body {
            background: #f5f7fa;
            color: #2d3748;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: var(--secondary);
            color: white;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 15px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 1.8rem;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        .content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 20px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-warning { background: var(--warning); }
        .btn-danger { background: var(--danger); }
        .btn-success { background: var(--success); }
        
        .servers-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
        }
        
        .server-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-left: 4px solid var(--primary);
        }
        
        .server-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 20px;
        }
        
        .server-name {
            font-size: 1.4rem;
            color: var(--secondary);
            margin-bottom: 5px;
        }
        
        .server-type {
            background: #c6f6d5;
            color: #22543d;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .server-status {
            text-align: right;
        }
        
        .status-online {
            background: var(--success);
            color: white;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .status-offline {
            background: var(--danger);
            color: white;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .server-url {
            background: #f7fafc;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 15px;
            font-family: monospace;
            font-size: 0.9rem;
            word-break: break-all;
        }
        
        .server-stats {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .clients-count {
            display: flex;
            align-items: center;
            gap: 8px;
            font-weight: 600;
            color: var(--secondary);
        }
        
        .server-actions {
            display: flex;
            gap: 10px;
        }
        
        .server-actions .btn {
            flex: 1;
        }
        
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #c6f6d5;
            color: #22543d;
            border: 1px solid #9ae6b4;
        }
        
        .alert-danger {
            background: #fed7d7;
            color: #742a2a;
            border: 1px solid #feb2b2;
        }
        
        @media (max-width: 768px) {
            .admin-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
            }
            
            .page-header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .servers-grid {
                grid-template-columns: 1fr;
            }
            
            .server-header {
                flex-direction: column;
                gap: 10px;
            }
            
            .server-status {
                text-align: left;
            }
            
            .server-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>📺 GESTOR DREEYTV</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="../index.php">📊 Dashboard</a></li>
                <li><a href="../clientes/clientes.php">👨‍💼 Clientes</a></li>
                <li><a href="../planos/planos.php">📋 Planos</a></li>
                <li><a href="servidores.php" class="active">🖥️ Servidores</a></li>
                <?php if ($_SESSION['usuario_tipo'] == 'admin'): ?>
                    <li><a href="../usuarios/usuarios.php">👥 Usuários</a></li>
                <?php endif; ?>
                <li><a href="../senha/alterar_senha.php">🔑 Alterar Senha</a></li>
                <li><a href="../logout.php">🚪 Sair</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="header">
                <h1>Gestão de Servidores</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo substr($_SESSION['usuario_nome'], 0, 1); ?></div>
                    <div>
                        <div style="font-weight: 600;"><?php echo $_SESSION['usuario_nome']; ?></div>
                        <div style="font-size: 0.9rem; color: #666;"><?php echo ucfirst($_SESSION['usuario_tipo']); ?></div>
                    </div>
                    <a href="../logout.php" class="btn" style="background: var(--danger);">🚪 Sair</a>
                </div>
            </div>
            
            <div class="content">
                <div class="page-header">
                    <h2>Servidores Disponíveis</h2>
                    <a href="criar_servidor.php" class="btn">➕ Novo Servidor</a>
                </div>

                <?php if (isset($_GET['sucesso'])): ?>
                    <div class="alert alert-success">
                        <strong>✅ Sucesso!</strong> Servidor criado/editado com sucesso!
                    </div>
                <?php endif; ?>

                <div class="servers-grid">
                    <?php foreach ($servidores as $servidor): ?>
                        <div class="server-card">
                            <div class="server-header">
                                <div>
                                    <div class="server-name"><?php echo htmlspecialchars($servidor['nome']); ?></div>
                                    <span class="server-type"><?php echo htmlspecialchars($servidor['tipo']); ?></span>
                                </div>
                                <div class="server-status">
                                    <span class="status-<?php echo $servidor['status'] == 'ativo' ? 'online' : 'offline'; ?>">
                                        <?php echo $servidor['status'] == 'ativo' ? '✅ Online' : '❌ Offline'; ?>
                                    </span>
                                </div>
                            </div>

                            <div class="server-url">
                                🔗 <?php echo htmlspecialchars($servidor['url']); ?>
                            </div>

                            <div class="server-stats">
                                <div class="clients-count">
                                    <span>👥</span>
                                    <span><?php echo $clientes_por_servidor[$servidor['id']] ?? 0; ?> clientes</span>
                                </div>
                                <div style="font-size: 0.9rem; color: #666;">
                                    Criado em <?php echo date('d/m/Y', strtotime($servidor['data_criacao'])); ?>
                                </div>
                            </div>

                            <div class="server-actions">
                                <a href="editar_servidor.php?id=<?php echo $servidor['id']; ?>" 
                                   class="btn btn-warning">✏️ Editar</a>
                                <a href="excluir_servidor.php?id=<?php echo $servidor['id']; ?>&csrf_token=<?php echo $security->generateCSRFToken(); ?>" 
                                   class="btn btn-danger"
                                   onclick="return confirm('Tem certeza que deseja excluir este servidor?')">
                                   🗑️ Excluir
                                </a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <?php if (empty($servidores)): ?>
                    <div style="text-align: center; padding: 60px 20px; color: #666;">
                        <div style="font-size: 4rem; margin-bottom: 20px;">🖥️</div>
                        <h3 style="color: var(--secondary); margin-bottom: 10px;">Nenhum servidor cadastrado</h3>
                        <p style="margin-bottom: 30px;">Comece criando seu primeiro servidor para atribuir aos clientes.</p>
                        <a href="criar_servidor.php" class="btn">➕ Criar Primeiro Servidor</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>